define(['./_baseToPairs', './keys'], function(baseToPairs, keys) {

  'use strict';

  /**
   * Creates an array of own enumerable key-value pairs for `object` which
   * can be consumed by `_.fromPairs`.
   *
   * @static
   * @memberOf _
   * @category Object
   * @param {Object} object The object to query.
   * @returns {Array} Returns the new array of key-value pairs.
   * @example
   *
   * function Foo() {
   *   this.a = 1;
   *   this.b = 2;
   * }
   *
   * Foo.prototype.c = 3;
   *
   * _.toPairs(new Foo);
   * // => [['a', 1], ['b', 2]] (iteration order is not guaranteed)
   */
  function toPairs(object) {
    return baseToPairs(object, keys(object));
  }

  return toPairs;
});
